<?php
/**
 * The7 Elementor plugin compatibility class.
 * @since   7.7.0
 * @package The7
 */

use Elementor\Core\Settings\Manager as Settings_Manager;
use Elementor\Plugin as Elementor;
use ElementorPro\Modules\LoopBuilder\Documents\Loop as LoopDocument;
use ElementorPro\Modules\ThemeBuilder\Documents\Theme_Document;
use ElementorPro\Modules\ThemeBuilder\Module as ThemeBuilderModule;
use The7\Mods\Compatibility\Elementor\Pro\Modules\Dynamic_Tags\The7\Module as DynamicTagsModule;
use The7\Mods\Compatibility\Elementor\The7_Elementor_Modules;
use The7\Mods\Compatibility\Elementor\The7_Elementor_Page_Settings;
use The7\Mods\Compatibility\Elementor\The7_Elementor_Template_Manager;
use The7\Mods\Compatibility\Elementor\The7_Elementor_Widgets;
use The7\Mods\Compatibility\Elementor\The7_Kit_Manager_Control;
use The7\Mods\Compatibility\Elementor\The7_Schemes_Manager_Control;

defined('ABSPATH') || exit;

/**
 * Class The7_Elementor_Compatibility
 */
class The7_Block_Theme_Compatibility
{

    /**
     * Instance.
     * @since  1.0.0
     * @access public
     * @static
     * @var The7_Block_Theme_Compatibility
     */
    public static $instance = null;
    private static $templates_to_ignore = [
		'theme.json',
        'templates/index.html',
        'block-templates/index.html',
    ];

    /**
     * Instance.
     * Ensures only one instance of the plugin class is loaded or can be loaded.
     * @return The7_Block_Theme_Compatibility An instance of the class.
     * @since  1.0.0
     * @access public
     * @static
     */
    public static function instance()
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
            self::$instance->bootstrap();
        }

        return self::$instance;
    }

    /**
     * Bootstrap module.
     */
    public function bootstrap()
    {
        // add_theme_support( 'block-template-parts' ); if activate can use block_template_part( 'header' ) inside php templates

		if ( the7_is_gutenberg_theme_mode_active() ) {
			// TODO: Maybe delete since it's not registered in theme-setup.php for Gutenberg mode.
			remove_filter( 'enqueue_block_editor_assets', 'presscore_editor_frame_styles' );
			add_action( 'init', [ $this, 'add_pattern_categories' ] );
            add_action('init', [$this, 'register_block_styles']);
		} else {
			remove_theme_support( 'block-templates' );

			add_filter( 'theme_file_path', [ $this, 'is_block_theme_filter' ], 10, 2 );
			wp_get_theme()->cache_delete();
		}
    }

    function register_block_styles() {
        register_block_style( 'core/button', array(
            'name'         => 'accent-2',
            'label'        => __( 'Fill 2', 'the7mk2' )
        ) );
    }

    /**
     * Register pattern categories
     * @return void
     * @since Twenty Twenty-Four 1.0
     */
    public static function add_pattern_categories()
    {

        register_block_pattern_category(
            'dt-the7_page',
            array(
                'label'       => _x('Pages', 'Block pattern category', 'the7mk2'),
                'description' => __('A collection of full page layouts . ', 'the7mk2'),
            )
        );
    }

    public static function is_block_theme_filter($path, $file)
    {
        if (in_array($file, self::$templates_to_ignore)) {
            return '';
        }

        return $path;
    }
}
